<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'paktuaslotrtp_blog_db'); // Ganti dengan username database cPanel
define('DB_PASS', '@njr}-NGw.PW^zb@'); // Ganti dengan password database cPanel
define('DB_NAME', 'paktuaslotrtp_blog_db'); // Ganti dengan nama database cPanel

// Create database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    die("Koneksi database gagal: " . $e->getMessage());
}

// Create tables if not exists
function createTables($pdo) {
    $queries = [
        "CREATE TABLE IF NOT EXISTS categories (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(100) NOT NULL,
            slug VARCHAR(100) UNIQUE NOT NULL,
            description TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )",
        
        "CREATE TABLE IF NOT EXISTS articles (
            id INT AUTO_INCREMENT PRIMARY KEY,
            title VARCHAR(255) NOT NULL,
            slug VARCHAR(255) UNIQUE NOT NULL,
            content LONGTEXT NOT NULL,
            excerpt TEXT,
            featured_image VARCHAR(255),
            category_id INT,
            author VARCHAR(100) DEFAULT 'Admin',
            status ENUM('published', 'draft') DEFAULT 'draft',
            views INT DEFAULT 0,
            published_at TIMESTAMP NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE SET NULL
        )",
        
        "CREATE TABLE IF NOT EXISTS settings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            setting_key VARCHAR(100) UNIQUE NOT NULL,
            setting_value TEXT,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )"
    ];
    
    foreach ($queries as $query) {
        try {
            $pdo->exec($query);
        } catch(PDOException $e) {
            // Table mungkin sudah ada, lanjutkan
        }
    }
    
    // Insert default categories
    $default_categories = [
        ['Teknologi', 'teknologi', 'Artikel seputar teknologi terbaru'],
        ['Bisnis', 'bisnis', 'Tips dan strategi bisnis'],
        ['Kesehatan', 'kesehatan', 'Informasi kesehatan dan gaya hidup sehat'],
        ['Gaya Hidup', 'gaya-hidup', 'Trend dan tips gaya hidup']
    ];
    
    $stmt = $pdo->prepare("INSERT IGNORE INTO categories (name, slug, description) VALUES (?, ?, ?)");
    foreach ($default_categories as $category) {
        $stmt->execute($category);
    }
}

// Panggil fungsi create tables
createTables($pdo);
?>