<?php
if (!isset($_GET['id'])) {
    header('Location: index.php');
    exit;
}

$article_id = intval($_GET['id']);
$stmt = $pdo->prepare("
    SELECT a.*, c.name as category_name 
    FROM articles a 
    LEFT JOIN categories c ON a.category_id = c.id 
    WHERE a.id = ? AND a.status = 'published'
");
$stmt->execute([$article_id]);
$article = $stmt->fetch();

if (!$article) {
    header('Location: index.php');
    exit;
}

// Update view count
$pdo->prepare("UPDATE articles SET views = views + 1 WHERE id = ?")->execute([$article_id]);

// Get related articles
$related_stmt = $pdo->prepare("
    SELECT * FROM articles 
    WHERE category_id = ? AND id != ? AND status = 'published' 
    ORDER BY published_at DESC 
    LIMIT 3
");
$related_stmt->execute([$article['category_id'], $article_id]);
$related_articles = $related_stmt->fetchAll();
?>
<div class="container py-5">
    <div class="row">
        <div class="col-lg-8">
            <!-- Article Content -->
            <article class="blog-article">
                <nav aria-label="breadcrumb" class="mb-4">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item"><a href="index.php?page=home">Artikel</a></li>
                        <li class="breadcrumb-item active"><?php echo htmlspecialchars($article['title']); ?></li>
                    </ol>
                </nav>

                <header class="article-header mb-4">
                    <h1 class="article-title"><?php echo htmlspecialchars($article['title']); ?></h1>
                    <div class="article-meta text-muted mb-3">
                        <span class="me-3">
                            <i class="fas fa-user me-1"></i>
                            <?php echo htmlspecialchars($article['author']); ?>
                        </span>
                        <span class="me-3">
                            <i class="fas fa-calendar me-1"></i>
                            <?php echo date('d M Y', strtotime($article['published_at'])); ?>
                        </span>
                        <span class="me-3">
                            <i class="fas fa-eye me-1"></i>
                            <?php echo $article['views'] + 1; ?> views
                        </span>
                        <span class="badge bg-primary">
                            <?php echo htmlspecialchars($article['category_name']); ?>
                        </span>
                    </div>
                </header>

                <?php if ($article['featured_image']): ?>
                <div class="article-image mb-4">
                    <img src="assets/images/uploads/<?php echo $article['featured_image']; ?>" 
                         class="img-fluid rounded" 
                         alt="<?php echo htmlspecialchars($article['title']); ?>">
                </div>
                <?php endif; ?>

                <div class="article-content">
                    <?php echo nl2br(htmlspecialchars($article['content'])); ?>
                </div>

                <div class="article-tags mt-4">
                    <strong>Tags:</strong>
                    <span class="badge bg-secondary">Togel</span>
                    <span class="badge bg-secondary">Prediksi</span>
                    <span class="badge bg-secondary"><?php echo htmlspecialchars($article['category_name']); ?></span>
                </div>
            </article>

            <!-- Related Articles -->
            <?php if (!empty($related_articles)): ?>
            <section class="related-articles mt-5">
                <h3 class="mb-4">Artikel Terkait</h3>
                <div class="row">
                    <?php foreach ($related_articles as $related): ?>
                    <div class="col-md-4 mb-3">
                        <div class="card h-100">
                            <div class="card-body">
                                <h5 class="card-title">
                                    <a href="?page=article&id=<?php echo $related['id']; ?>" class="text-decoration-none">
                                        <?php echo htmlspecialchars($related['title']); ?>
                                    </a>
                                </h5>
                                <p class="card-text text-muted small">
                                    <?php echo date('d M Y', strtotime($related['published_at'])); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </section>
            <?php endif; ?>
        </div>

        <div class="col-lg-4">
            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Categories -->
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Kategori</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $categories = $pdo->query("
                            SELECT c.*, COUNT(a.id) as article_count 
                            FROM categories c 
                            LEFT JOIN articles a ON c.id = a.category_id AND a.status = 'published'
                            GROUP BY c.id
                        ")->fetchAll();
                        ?>
                        <ul class="list-group list-group-flush">
                            <?php foreach ($categories as $cat): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <a href="index.php?page=home&category=<?php echo $cat['id']; ?>" class="text-decoration-none">
                                    <?php echo htmlspecialchars($cat['name']); ?>
                                </a>
                                <span class="badge bg-primary rounded-pill"><?php echo $cat['article_count']; ?></span>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>

                <!-- Popular Articles -->
                <div class="card">
                    <div class="card-header bg-warning">
                        <h5 class="mb-0">Artikel Populer</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $popular_articles = $pdo->query("
                            SELECT * FROM articles 
                            WHERE status = 'published' 
                            ORDER BY views DESC 
                            LIMIT 5
                        ")->fetchAll();
                        ?>
                        <div class="list-group list-group-flush">
                            <?php foreach ($popular_articles as $popular): ?>
                            <a href="?page=article&id=<?php echo $popular['id']; ?>" 
                               class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?php echo htmlspecialchars($popular['title']); ?></h6>
                                </div>
                                <small class="text-muted">
                                    <?php echo $popular['views']; ?> views
                                </small>
                            </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>